﻿<%@ Control Language="C#" %>
<%@ Import Namespace="Kesion.Publics" %>
<%@ Import Namespace="Kesion.Cache" %>
<%@ Import Namespace="Kesion.Components" %>
<%@ Import Namespace="Kesion.BLL" %>
<%@ Import Namespace="Kesion.HtmlTags" %>
<%@ Import Namespace="Kesion.XML" %>
<%@ Import Namespace="Newtonsoft.Json" %>
<%@ Import Namespace="Newtonsoft.Json.Linq" %>
<%@ Import Namespace="System.Data" %>
<%@ Import Namespace="System.Net" %>
<%@ Import Namespace="System.IO" %>
<script runat="server" type="text/C#">

    dynamic __user = HttpContext.Current.Items["user"];                //初始化用户信息
    public UserInfo __info = null;
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckUserLogin.Run();
        if (!IsPostBack)
        {
            __info = UserManage.GetUserInfo();
        }
    }

    #region    获取互动直播的类型信息
    /// <summary>
    /// 获取互动直播的类型信息
    /// </summary>
    /// <param name="ClassType">班级类型</param>
    /// <returns>返回信息</returns>
    public string GetClassType(int ClassType)
    {
        string type = string.Empty;
        switch (ClassType)
        {
            case 0:
                type = "大班课";
                break;
            case 1:
                type = "小班课";
                break;
            case 2:
                type = "一对一";
                break;
        }
        return type;
    }

    #endregion


    /// <summary>
    /// 获取用户学习接口信息
    /// </summary>
    /// <returns></returns>
    public string GetComIngType(int classid)
    {
        string postdate = "{";
        postdate += "\"appid\":\"" + Utils.RemoveXss(XmlObject.ReadXmlReturnAttribute(Utils.GetMapPath(MyCache.GetCacheConfig(0) + "config/online.config"), "//admin/info", "appid")) + "\",";
        postdate += "\"token\":\"" + GetAccessToken() + "\",";
        postdate += "\"memberid\":\""+ UserManage.GetUserInfo().UserID+"\",";
        postdate += "\"classid\":\""+classid+"\",";
        postdate += "\"wxid\":\"" + Utils.RemoveXss(XmlObject.ReadXmlReturnAttribute(Utils.GetMapPath(MyCache.GetCacheConfig(0) + "config/online.config"), "//admin/info", "wxid")) + "\",";
        postdate += "\"sex\":\""+(UserManage.GetUserInfo().Sex=="男"?"1":"2")+"\","; //1-男  2-女
        postdate += "\"headpic\":\"\",";
        postdate += "\"name\":\""+UserManage.GetUserInfo().UserName+"\"}";
        string response = PostDate(postdate, 7);
        string LoginType = "";
        if (!string.IsNullOrEmpty(response))
        {
            JObject json = JObject.Parse(response);
            JObject jsonstu = JObject.Parse(json["studentLogin"].ToString());
            LoginType += "<a href='" + jsonstu["url"].ToString() + "' target='_blank' >进入教室</a>";
            LoginType += "<span>App端账号密码：<span>账号：'" + jsonstu["username"].ToString() + "'</span><span>密码：'" + jsonstu["password"].ToString() + "'</span></span>";
        }
        else {
            LoginType += "暂无信息！";
        }
        return LoginType;
    }


    /// <summary>
    /// 获取临时token
    /// </summary>
    /// <returns></returns>
    private string GetAccessToken()
    {
        string postdate = "{";
        postdate += "\"appid\":\"" + Utils.RemoveXss(XmlObject.ReadXmlReturnAttribute(Utils.GetMapPath(MyCache.GetCacheConfig(0) + "config/online.config"), "//admin/info", "appid")) + "\",";
        postdate += "\"secret\":\"" + Utils.RemoveXss(XmlObject.ReadXmlReturnAttribute(Utils.GetMapPath(MyCache.GetCacheConfig(0) + "config/online.config"), "//admin/info", "appsecret")) + "\"}";
        string response = PostDate(postdate, 1);
        if (!string.IsNullOrEmpty(response))
        {
            JObject json = JObject.Parse(response);
            return json["accesstoken"].ToString();
        }
        else {
            return string.Empty;
        }
    }

        /// <summary>
        /// 向服务器传输相关数据
        /// </summary>
        /// <param name="postdata">保存的数据json</param>
        /// <param name="type">请求的接口类型  默认注册接口</param>
        /// 1-获取动态令牌    2-获取网校信息   3-获取连麦币和直播并发的购买记录信息
        private string PostDate(string postdata, int type = 0)
        {
            #region 向服务器传输保存订单的相关数据信息
            string responseData = String.Empty;
            try
            {
                string url = "https://open.ketangjie.com/Json/index.php?act=Api.registe&";
                switch (type)
                {
                    case 7://进入直播页面信息
                        url = "https://open.ketangjie.com/Json/index.php?act=Api.studentLogin";
                        break;
                   
                    case 1://获取动态令牌
                        url = "https://open.ketangjie.com/Json/index.php?act=Api.accesstoken";
                        break;
                }

                HttpWebRequest req = (HttpWebRequest)HttpWebRequest.Create(url);//这是你要提交的url
                Encoding encoding = Encoding.UTF8;
                byte[] bs = Encoding.UTF8.GetBytes(postdata.ToString());//UTF-8            
                req.Method = "POST";
                req.ContentType = "application/x-www-form-urlencoded";
                req.ContentLength = bs.Length;

                //处理HttpWebRequest访问https有安全证书的问题（ 请求被中止: 未能创建 SSL/TLS 安全通道。）
                ServicePointManager.ServerCertificateValidationCallback += (s, cert, chain, sslPolicyErrors) => true;
                ServicePointManager.SecurityProtocol = SecurityProtocolType.Tls12 | SecurityProtocolType.Tls11 | SecurityProtocolType.Tls;

                //提交服务器相关参数信息
                using (Stream reqStream = req.GetRequestStream())
                {
                    reqStream.Write(bs, 0, bs.Length);
                    reqStream.Close();
                }
                //服务器返回来的参数信息
                using (HttpWebResponse response = (HttpWebResponse)req.GetResponse())
                {
                    using (StreamReader reader = new StreamReader(response.GetResponseStream(), encoding))
                    {
                        responseData = reader.ReadToEnd().ToString();
                        return responseData;
                    }
                }
            }
            catch (Exception e)
            {
                return responseData;
            }
            #endregion
        }
   
</script>

<div class="r_tybox nomar">		 
	<div class="r_title">我的面授课程</div>
	<div class="myCourse">
		   <ul id="mainCourse">
                 <%
            int recordcount, pagecount;
            int CurrPage = new BasicField().GetCurrPage;
            int PageSize = 2;
            //互动课程的学习方式
			string sqlParam = "  (KS_CosOrder a inner join KS_CosOrderItem c on a.orderid=c.orderid)inner join KS_Course b on c.courseid=b.courseid where  a.status=1 and  a.username = '" + UserManage.GetUserInfo().UserName + "' and b.CourseID in (select CourseID from KS_Course where TeachWay=6)";
			using (DataTable dt = DataFactory.GetPage("b.*", sqlParam, "c.ID", "order by  a.paytime desc", CurrPage, PageSize, out recordcount, out pagecount))
			{
				if (dt.Rows.Count > 0)
				{
					foreach (DataRow dr in dt.Rows)
					{
                %>
               <li>
                   <div class="image">
                       <img src="<%=dr["photourl"].ToString() %>" onerror="this.src='/sysimg/nopic.gif'" alt="<%=dr["name"].ToString() %>">
                   </div>
                   <div class="name"><a href="<%=BaseFun.GetRewriteUrl("courseview",Utils.StrToInt(dr["courseid"].ToString())) %>" title="前台页" target="_blank"><%=dr["name"].ToString() %></a></div>
                   <div class="info"><span>讲师：<%=UserManage.GetUserInfo(Utils.StrToInt(dr["Tcid"].ToString())).UserName %> </span><span>班型：<%=GetClassType(Utils.StrToInt(dr["LiveType"].ToString())) %></span></div>
                   <div class="button"><a target="_blank" href="<%=BaseFun.GetRewriteUrl("courseview",Utils.StrToInt(dr["courseid"].ToString())) %>">查看详情</a></div>
                   <div class="link">
                       <%=GetComIngType(Utils.StrToInt(dr["Uid"])) %>
                   </div>
               </li>
               <%
					}
				}
				else
				{
					KSCMS.W("<div class=\"empty\">您还没有购买任何互动课程</div><style>.cz_btn{display:none;}</style>");
				}
			}
        %>
		   </ul>

	</div>
    
	<div class="cz_btn">
		<%
            #region 分页
            string PageStr = "[KS:PageStr2]";
            BasicField.ReplaceFilterPage(ref PageStr, CurrPage, PageSize, pagecount, recordcount);
            KSCMS.W(PageStr);
            #endregion
         %>
	</div>
</div>

